import {
        async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { FhirFindComponent } from './find.component'
import { FhirFind } from '../../../mccf-data/fhir/fhir-find'

describe('FhirFindComponent', () => {
  let component: FhirFindComponent
  let fixture: ComponentFixture<FhirFindComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        FhirFindComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(FhirFindComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  beforeEach(()=>{
    let fnd = new FhirFind()
    fnd.ien = '1214'
    fnd.identifier.push('123456')
    fnd.identifier.push('123457')
    component.results.push(fnd)
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have a results loaded', ((done)=>{
    expect(component.results.length).toEqual(1)
    expect(component.results[0].ien).toEqual('1214')
    expect(component.results[0].identifier.length).toEqual(2)
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))
})
